/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.tasklet;

import com.ibm.hwmca.fw.connmgr.Connection;
import com.ibm.hwmca.fw.system.ClientUserContext;
import com.ibm.hwmca.fw.tasklet.TaskletException;
import com.ibm.hwmca.fw.tasklet.TaskletRequest;
import com.ibm.hwmca.fw.tasklet.TaskletResponse;
import com.ibm.hwmca.fw.tasklet.impl.TaskletData;
import com.ibm.hwmca.fw.tasklet.impl.response.ErrorResponseData;
import com.ibm.hwmca.fw.tasklet.xport.AbnormalTaskletTerminationException;
import com.ibm.hwmca.fw.tasklet.xport.ConversationComponent;
import com.ibm.hwmca.fw.tasklet.xport.TaskletClient;
import com.ibm.hwmca.fw.tasklet.xport.TaskletCommunicationClient;
import com.ibm.hwmca.fw.util.Trace;

public class Client
extends TaskletClient {
    private static final String TRACE_MASKT = "XTSKCCLT";
    private static final String TRACE_MASKF = "XTSKCCLF";
    private static final String TRACE_MASKD = "XTSKCCLD";

    public Client(String taskletClassName, Object initData, ClientUserContext clientUserContext) throws TaskletException {
        super(new TaskletData(), clientUserContext);
        Trace.trace(TRACE_MASKF, "[Client:" + this.traceId + "] <init> for " + taskletClassName);
        this.taskletData.setServerTaskletClass(taskletClassName);
        this.taskletData.setInitializationData(initData);
    }

    public Client(String taskletClassName, Object initData) throws TaskletException {
        this(taskletClassName, initData, null);
    }

    public Client(TaskletCommunicationClient taskletCommunicationClient, String taskletClassName, Object initData) throws TaskletException {
        super(taskletCommunicationClient, new TaskletData());
        Trace.trace(TRACE_MASKF, "[Client:" + this.traceId + "] <init> for " + taskletClassName);
        this.taskletData.setServerTaskletClass(taskletClassName);
        this.taskletData.setInitializationData(initData);
    }

    public TaskletResponse init() throws TaskletException {
        Trace.trace(TRACE_MASKF, "[Client:" + this.traceId + "] init()");
        return this.verifyResponse(super.init(null));
    }

    private TaskletResponse verifyResponse(TaskletResponse response) throws TaskletException {
        if (response.getResponseData() instanceof ErrorResponseData) {
            Trace.trace(TRACE_MASKF, "[Client:" + this.traceId + "] verifyResponse() detects ERROR response, creating/throwing TaskletException");
            ErrorResponseData erd = (ErrorResponseData)response.getResponseData();
            if (erd.getCause() != null) {
                throw new TaskletException(erd.getCause());
            }
            throw new TaskletException(erd.getErrorMsg().toString());
        }
        return response;
    }

    public void terminate() {
        Trace.trace(TRACE_MASKF, "[Client:" + this.traceId + "] terminate()");
        super.terminate();
    }

    public void abnormalTermination(AbnormalTaskletTerminationException exception) {
    }

    public Connection connect(String name, ConversationComponent initData) throws TaskletException {
        Trace.trace(TRACE_MASKF, "[Client:" + this.traceId + "] connect(" + name + ", " + initData + ")");
        return super.connect(name, initData);
    }

    public TaskletResponse request(TaskletRequest request) throws TaskletException {
        Trace.trace(TRACE_MASKF, "[Client:" + this.traceId + "] request()");
        return this.verifyResponse(super.request(request));
    }

    public boolean isAuthenticated() {
        return super.isAuthenticated();
    }
}

